% Figure 1, GDP
% h1 = figure('name','Output gap and GDP growth');
% subplot(2,2,1);
% p = plot(prange,[prevMPC.lgdp_gap s.lgdp_gap],'LineWidth',2); 
% legend('PrevQPM','Current');
% set(p(1),'LineStyle',':','LineWidth',1.5,'Color','k');
% highlight(mpcrng);
% title('Output gap (%)');
% 
%         y1 = ylim;
%         xx = 2017.5:0.25:2019.875;
%         yx = s.lgdp_gap(mpcrng);
%         b = num2str(yx,'%.1f');
%         c = cellstr(b);
%         dx = -0.125;
%         dy = -(y1(2)-y1(1))/20;
%         text(xx+dx, yx+dy, c,'FontSize',8);     
% 
% subplot(2,2,3);
% bar(prange,s.lgdp_gap);
% highlight(mpcrng);
% title('error');
% 
%         y1 = ylim;
%         xx = 2017.5:0.25:2019.875;
%         yx = s.lgdp_gap(mpcrng);
%         b = num2str(yx,'%.1f');
%         c = cellstr(b);
%         dx = -0.125;
%         dy = -(y1(2)-y1(1))/20;
%         text(xx+dx, yx+dy, c,'FontSize',8); 
% 
% subplot(2,2,2);
% p = plot(prange,[s.dot_gdp s.dot4_gdp],'LineWidth',2); 
% set(p(2),'LineStyle',':');
% highlight(mpcrng);
% title('GDP growth (qqa and yy)');
% 
%         y1 = ylim;
%         xx = 2017.5:0.25:2019.875;
%         yx = s.dot_gdp(mpcrng);
%         b = num2str(yx,'%.1f');
%         c = cellstr(b);
%         dx = -0.125;
%         dy = -(y1(2)-y1(1))/20;
%         text(xx+dx, yx+dy, c,'FontSize',8);     

% return

subplot(2,2,4);
bar(prange,s.e_lgdp_gap);
if verLessThan('matlab','8.4.0')     
    highlight(mpcrng); 
end
title('error');

% return
% Figure 2, CPI
h2 = figure('name','CPI: Core and Food');
subplot(2,2,1);
p = plot(prange,[prevMPC.dot4_cpi_core s.dot4_cpi_core prevMPC.dot4_cpi s.dot4_cpi],'LineWidth',2); 
legend([p(1) p(2) p(4)],'Prev Core CPI','Current Core CPI','CPI');
set(p(1),'LineStyle',':','LineWidth',1.5,'Color','r');
set(p(2),'Color','r');
set(p(3),'LineStyle',':','LineWidth',1.5,'Color','b');
if verLessThan('matlab','8.4.0')     
    highlight(mpcrng); 
end
title('Core CPI (and Headline)');

subplot(2,2,3);
bar(prange,s.e_dot_cpi_serv);
if verLessThan('matlab','8.4.0')     
    highlight(mpcrng); 
end
title('error');

VARcpifood = log(foodVAR.cpifood)*100;
dot4_VARcpifood = VARcpifood - VARcpifood{-4};

subplot(2,2,2);
p = plot(prange,[prevMPC.dot4_cpi_food s.dot4_cpi_food s.dot4_cpi dot4_VARcpifood],'LineWidth',2); 
legend('Prev Food CPI','Current Food CPI','CPI','CPI food (VAR)');
set(p(1),'LineStyle',':','LineWidth',1.5,'Color','k');
set(p(2),'Color','r');
set(p(3),'Color','c');
set(p(4),'LineStyle',':','LineWidth',2,'Color','b');
if verLessThan('matlab','8.4.0')     
    highlight(mpcrng); 
end
title('Food CPI');

subplot(2,2,4);
bar(prange,s.e_dot_cpi_food);
if verLessThan('matlab','8.4.0')     
    highlight(mpcrng); 
end
title('error');

% return

% Figure 3, wages and policy rate
h3 = figure('name','Wages and Repo');
subplot(2,2,1);
p = plot(prange,[prevMPC.dot4_w s.dot4_w prevMPC.dot4_cpi s.dot4_cpi],'LineWidth',2); 
legend([p(1) p(2) p(4)],'PrevQPM','Current','CPI','Location','NorthWest');
set(p(1),'LineStyle',':','LineWidth',1.5,'Color','k');
set(p(2),'Color','r');
set(p(3),'LineStyle',':','LineWidth',1.5,'Color','k');
if verLessThan('matlab','8.4.0')     
    highlight(mpcrng); 
end
title('Wages (and Headline)');

subplot(2,2,3);
bar(prange,s.e_dot_w);
if verLessThan('matlab','8.4.0')     
    highlight(mpcrng); 
end
title('error');

subplot(2,2,2);
p = plot(prange,[prevMPC.rn   s.rn],'LineWidth',2); 
legend('PrevQPM','Current','Location','NorthWest'   );
set(p(1),'LineStyle',':','LineWidth',1.5,'Color','k');
set(p(2),'Color','r');
if verLessThan('matlab','8.4.0')     
    highlight(mpcrng); 
end
title('rn');

subplot(2,2,4);
bar(prange,s.e_rn); 
if verLessThan('matlab','8.4.0')     
    highlight(mpcrng); 
end
title('error');

% Maximise figure window automatically
maxwinsize = [ 1           1        1606         964 ];
%    defwinsize = get(gcf,'position');	% default size 
set(gcf,'position',maxwinsize);	% maximize

% return
% Figure 4, REER gap and NEER qqa
h4 = figure('name','REER gap and NEER qqa');
subplot(2,2,1);
p = plot(prange,[prevMPC.lz s.lz s.lz_eq],'LineWidth',2); 
legend([p(1) p(2) p(3)],'Prev lz','Current lz','lz eq');
set(p(1),'LineStyle',':','LineWidth',1.5,'Color','r');
set(p(2),'Color','r');
set(p(3),'LineStyle',':','LineWidth',1.5,'Color','b');

set(p(2),'LineStyle',':');
if verLessThan('matlab','8.4.0')     
    highlight(mpcrng); 
end
title('REER gap and eq.');

subplot(2,2,3);
bar(prange,s.e_ls);
if verLessThan('matlab','8.4.0')     
    highlight(mpcrng); 
end
title('error');

subplot(2,2,2);
plot(prange,[prevMPC.dot_s s.dot_s],'LineWidth',2); 
legend([p(1) p(2)],'Prev ls qqa','Current ls qqa');
set(p(1),'LineStyle',':','LineWidth',1.5,'Color','k');
set(p(2),'Color','r');
if verLessThan('matlab','8.4.0')     
    highlight(mpcrng); 
end
title('NEER qqa');

subplot(2,2,4);
bar(prange,s.e_ls); 
if verLessThan('matlab','8.4.0')     
    highlight(mpcrng); 
end
title('error');

% Figure 5, CPI
h5 = figure('name','CPI');
subplot(2,1,1);
p = plot(prange,[s.dot4_cpi_core s.dot4_cpi],'LineWidth',2);  hold on;
set(p(2),'LineStyle',':');
bar(prange,s.e_dot_cpi_serv); 
if verLessThan('matlab','8.4.0')     
    highlight(mpcrng); 
end
title('Core CPI (and Headline)');

% close all;
% [ax h1 h2] = plotyy(prange,[s.dot4_cpi_core s.dot4_cpi],s.zeroline); 
% hold(ax(2),'on');
% bar(ax(2),prange,s.e_dot_cpi_core);


subplot(2,1,2);
p = plot(prange,[s.dot4_cpi_food s.dot4_cpi],'LineWidth',2);  hold on;
set(p(2),'LineStyle',':');
bar(prange,[s.e_dot_cpi_food]);
if verLessThan('matlab','8.4.0')
    highlight(mpcrng);
end
title('Food CPI');

% Figure 6, key variables - forecast summary
h6 = figure('name','Forecast summary');

if verLessThan('matlab','8.4.0')
    subplot(3,2,1);
    [p a b] = plotyy(prange,[prevMPC.rn s.rn], [prevMPC.rr s.rr]);
    set(a(2),'LineWidth',2,'Color','b'); set(b(2),'LineWidth',2,'Color','m')
    set(a(1),'LineStyle',':','LineWidth',1.5,'Color','b');
    set(b(1),'LineStyle',':','LineWidth',1.5,'Color','m');
    legend([a(2) b(2)],'Repo (nominal)','Real repo gap(rhs)'); 
    if verLessThan('matlab','8.4.0')     
        highlight(mpcrng); 
    end
    title('Repo (real and nominal)');
    axis tight;
    grid on;
    
    subplot(3,2,2);
    [p a b] = plotyy(prange,[prevMPC.dot4_cpi s.dot4_cpi], [prevMPC.dot4_cpi_core s.dot4_cpi_core]); title('CPI headline (yy)');
    set(a(2),'LineWidth',2,'Color','b'); set(b(2),'LineWidth',2,'Color','m')
    set(a(1),'LineStyle',':','LineWidth',1.5,'Color','b');
    set(b(1),'LineStyle',':','LineWidth',1.5,'Color','m');
    legend([a(2) b(2)],'Headline yy','Core yy (rhs)'); 
    if verLessThan('matlab','8.4.0')     
        highlight(mpcrng); 
    end
    axis tight;
    grid on;
    
    subplot(3,2,3);
    [p a b] = plotyy(prange,[prevMPC.dot4_cpi_food s.dot4_cpi_food diff(log(disag.FOOD),-4)*100], [prevMPC.dot4_w s.dot4_w]);
    title('CPI food and wages (yy)');
    set(a(2),'LineWidth',2,'Color','b'); set(b(2),'LineWidth',2,'Color','m')
    set(a(1),'LineStyle',':','LineWidth',1.5,'Color','b');
    set(b(1),'LineStyle',':','LineWidth',1.5,'Color','m');
    legend([a(2) a(3) b(2)],'CPI food yy','DIM food','Wages yy (rhs)'); 
    if verLessThan('matlab','8.4.0')     
        highlight(mpcrng); 
    end
    axis tight;
    grid on;
    
    subplot(3,2,4);
    [p a b] = plotyy(prange,[prevMPC.dot_cpi s.dot_cpi], [prevMPC.dot_cpi_core s.dot_cpi_core]); title('CPI headline (qqa)');
    set(a(2),'LineWidth',2,'Color','b'); set(b(2),'LineWidth',2,'Color','m')
    set(a(1),'LineStyle',':','LineWidth',1.5,'Color','b');
    set(b(1),'LineStyle',':','LineWidth',1.5,'Color','m');
    legend([a(2) b(2)],'Headline qqa','Core qqa (rhs)'); 
    if verLessThan('matlab','8.4.0')     
        highlight(mpcrng); 
    end
    axis tight;
    grid on;
end

subplot(3,2,5);
p = plot(prange,[prevMPC.dot_gdp s.dot_gdp],'LineWidth',2); title('GDP, qqa');
set(p(1),'LineStyle',':','LineWidth',1.5,'Color','m');
set(p(2),'Color','m');
if verLessThan('matlab','8.4.0')     
    highlight(mpcrng); 
end
% ylim([0 4]);
axis tight;
grid on;

subplot(3,2,6);
p = plot(prange,[prevMPC.lgdp_gap s.lgdp_gap],'LineWidth',2); 
set(p(1),'LineStyle',':','LineWidth',1.5,'Color','m');
set(p(2),'Color','m');
title('Output gap');
if verLessThan('matlab','8.4.0')     
    highlight(mpcrng); 
end
% ylim([0 4]);
axis tight;
grid on;

% Figure 7, NEER
h7 = figure('name','NEER');
subplot(2,2,1);
title('Nominal exchange rate (level)');
p = plot(prange,[prevMPC.ls s.ls],'LineWidth',2); 
set(p(1),'LineStyle',':','LineWidth',1.5,'Color','m');
set(p(2),'Color','m');
if verLessThan('matlab','8.4.0')     
    highlight(mpcrng); 
end
% ylim([0 4]);
axis tight;
grid on;

subplot(2,2,2);
p = plot(prange,[prevMPC.dot_s s.dot_s],'LineWidth',2);  title('Nominal depr qq');
set(p(1),'LineStyle',':','LineWidth',1.5,'Color','m');
set(p(2),'Color','m');
if verLessThan('matlab','8.4.0')     
    highlight(mpcrng); 
end
axis tight;
grid on;

subplot(2,2,3);
p = plot(prange,[prevMPC.rr_gap s.rr_gap],'LineWidth',2); title('Real repo - gap');
set(p(1),'LineStyle',':','LineWidth',1.5,'Color','m');
set(p(2),'Color','m');
if verLessThan('matlab','8.4.0')     
    highlight(mpcrng); 
end
axis tight;
grid on;

subplot(2,2,4);
p = plot(prange,[prevMPC.lz_gap s.lz_gap],'LineWidth',2); title('Real exch - gap');
set(p(1),'LineStyle',':','LineWidth',1.5,'Color','m');
set(p(2),'Color','m');
if verLessThan('matlab','8.4.0')     
    highlight(mpcrng); 
end
axis tight;
grid on;

h8 = figure('name','Real Term structure');
subplot(2,2,1);
p1 = plot(prange,[s.rr s.rr_eq]); 
set(p1(1),'LineWidth',2,'Color','b'); 
if verLessThan('matlab','8.4.0')     
    highlight(mpcrng); 
end
title('Real repo');
axis tight;
grid on;

subplot(2,2,2);
p1 = plot(prange,[s.rr40 s.rr_eq40]); 
set(p1(1),'LineWidth',2,'Color','b'); 
if verLessThan('matlab','8.4.0')     
    highlight(mpcrng); 
end
title('10yr real repo');
axis tight;
grid on;

subplot(2,2,3);
p1 = plot(prange,[s.lrr s.lrr_eq]); 
set(p1(1),'LineWidth',2,'Color','b'); 
if verLessThan('matlab','8.4.0')     
    highlight(mpcrng); 
end
title('Weighted long-run real repo (lrr)');
axis tight;
grid on;

subplot(2,2,4);
p1 = plot(prange(8):prange(end),[s.rr-s.rr_eq s.rr40-s.rr_eq40 s.lrr-s.lrr_eq]); 
set(p1,'LineWidth',2); 
if verLessThan('matlab','8.4.0')     
    highlight(mpcrng); 
end
legend('rr','10yr rr40','weighted lrr');
title('Real rate gaps');
axis tight;
grid on;

figure('name','Nominal Term structure');
p1 = plot(prange,[s.rn s.rn40]); 
% set(p1(1),'LineWidth',2,'Color','b'); 
if verLessThan('matlab','8.4.0')     
    highlight(mpcrng); 
end
legend('rn','10yr rn40');
title('Nominal term structure');
axis tight;
grid on;




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% % Figure 8, inflation and real rate gaps
% figure();
% subplot(2,2,1);
% plot(prange,s.lz,'LineWidth',2); title('RER gap');
% highlight(mpcrng);
% 
% subplot(2,2,2);
% p = plot(prange,[s.dot4_cpi_elec s.dot4_cpi_petr]); 
% title('CPI petrol and electricity (yy)'); 
% set(p(1),'LineWidth',2); set(p(2),'LineWidth',2)
% legend('Electricity yy','Petrol yy'); highlight(mpcrng);
% 
% subplot(2,2,3);
% p = plot(prange,[s.dot_cpi_food s.dot4_cpi_food]); title('CPI food'); 
% set(p(1),'LineWidth',2); set(p(2),'LineWidth',2)
% legend('qoq','yoy'); highlight(mpcrng);
% 
% subplot(2,2,4);
% plot(prange,s.rr,'LineWidth',2); title('RIR gap');
% highlight(mpcrng);
% 
% % Figure 9, wages
% figure();
% p = plot(prange,[s.dot_w s.dot4_w]); title('Wages (qqa)'); 
% set(p(1),'LineWidth',2); set(p(2),'LineWidth',2)
% legend('qoq','yoy'); highlight(mpcrng);
% axis tight;
% grid on;
% 
% % Figure 10, output gap and GDP growth (qqa and yoy)
% figure();
% subplot(2,1,1)
% plot(prange,[s.lgdp]); title('output gap (qqa)'); 
% legend('output gap'); highlight(mpcrng);
% axis tight;
% grid on;
% 
% subplot(2,1,2)
% p=plot(prange,[s.dot_gdp s.dot4_gdp]); title('GDP (qqa)'); 
% set(p(1),'LineWidth',2); set(p(2),'LineWidth',2)
% legend('qqa','yy'); highlight(mpcrng);
% axis tight;
% grid on;
%  
% % Figure 11, core inflation
% figure();
% p=plot(prange,[s.CPIXFEPRq s.CPIXFEPR]); title('CPI core (qqa)'); 
% set(p(1),'LineWidth',2); set(p(2),'LineWidth',2)
% legend('qoq','yoy'); highlight(mpcrng);
% axis tight;
% grid on;
% 
% % Figure 12, REER gap
% subplot(2,2,1);
% plot(prange,s.lz,'LineWidth',2); title('RER gap');
% highlight(mpcrng);
% 
% % Figure 13, administered price inflation
% subplot(2,2,2);
% p = plot(prange,[s.dot4_cpi_elec s.dot4_cpi_petr]); 
% title('CPI petrol and electricity (yy)'); 
% set(p(1),'LineWidth',2); set(p(2),'LineWidth',2)
% legend('Electricity yy','Petrol yy'); highlight(mpcrng);
% 
% % Figure 14, food inflation
% subplot(2,2,3);
% p = plot(prange,[s.dot_cpi_food s.dot4_cpi_food]); title('CPI food'); 
% set(p(1),'LineWidth',2); set(p(2),'LineWidth',2)
% legend('qoq','yoy'); highlight(mpcrng);
% 
% % Figure 15, real interest rate gap
% subplot(2,2,4);
% plot(prange,s.rr,'LineWidth',2); title('RIR gap');
% highlight(mpcrng);

% Table 1, forecast summary
list = {'CPIXFEPR','CPIFR','CPITR','rn','dot_s', 'rr_gap', ...
    'lz_gap','lgdp_gap','GDPMPRq','GDPMPR','SALAVR'};    
data = cell(length(list)*2,16);

for i = 1:length(list);
data((i-i)+i*2,1:16) = {mean(s.(list{i})(qq(2017,1):qq(2017,4))) ...
    s.(list{i})(qq(2018,1)) s.(list{i})(qq(2018,2)) s.(list{i})(qq(2018,3))...
    s.(list{i})(qq(2018,4)) mean(s.(list{i})(qq(2018,1):qq(2018,4)))...
    s.(list{i})(qq(2019,1)) s.(list{i})(qq(2019,2)) s.(list{i})(qq(2019,3))...
    s.(list{i})(qq(2019,4)) mean(s.(list{i})(qq(2019,1):qq(2019,4)))...
    s.(list{i})(qq(2020,1)) s.(list{i})(qq(2020,2)) s.(list{i})(qq(2020,3))...
    s.(list{i})(qq(2020,4)) mean(s.(list{i})(qq(2020,1):qq(2020,4))) };
end

fig = figure('name','Table');
columnformat = {'bank','bank','bank','bank','bank','bank','bank','bank', ...
    'bank','bank','bank','bank','bank','bank','bank','bank'};
t1 = uitable('Data',data, ...    
    'RowName',{'','Core CPI','','Food CPI','','CPI','','Repo', ...
    '','Nominal depreciation','','Real rate gap','','Real exch. gap', ...
    '','Output gap','','GDP growth, qqa','','GDP growth, yy','','wages, yy'}, ...
    'ColumnWidth',{100,50,50,50,50,100,50,50,50,50,100,50,50,50,50,100},...
    'ColumnFormat',columnformat, ...
    'ColumnName', {'2017','q1','q2','q3','q4', ...
                   '2018','q1','q2','q3','q4', ...
                   '2019','q1','q2','q3','q4','2020'}, ...
                   'Position', [0 10 1325 600],'FontS',8);  % 'Position', [100 350 1325 500]
      
%     'ColumnWidth',{50,30,30,30,30,50,30,30,30,30,50,30,30,30,30,50},...
%     'ColumnWidth',{100,50,50,50,50,100,50,50,50,50,100,50,50,50,50,100},...
set(fig, 'Units', 'normalized', 'Position', [0,0,1,1]);

% % Tabbed figures
% tabbedFig = figs2tabs([h1, h2, h3, h4, h5, h6, h7, fig]); 

% stackfigs;



h7 = figure('name','Policy variables');
 
subplot(2,2,1);
plot(qq(2010,1):qq(2018,4), [s.rn prevMPC.rn]);
legend('Repo (alternative)','Repo (baseline)');

subplot(2,2,2);
plot(qq(2010,1):qq(2018,4),[s.CPITR prevMPC.CPITR]);
legend('CPI (alternative)','CPI (baseline)');

subplot(2,2,3);
% plot(qq(2010,1):qq(2018,4),[s.dot4_s-prevMPC.dot4_s]);
% legend('NEER(alternaive)','NEER (baseline)');
plot(qq(2010,1):qq(2018,4),[s.lgdp_gap prevMPC.lgdp_gap]);
legend('Output gap (alternative)','Output gap (baseline)');

subplot(2,2,4);
plot(qq(2010,1):qq(2018,4),[s.rr prevMPC.rr]);
legend('Real interest rate (alternative)','Real interest rate (baseline)');

% figure;
% plot(qq(2010,1):qq(2018,4),[cumsum(prevMPC.lgdp_gap)/4-cumsum(s.lgdp_gap)/4]);
% legend('Sacrificed output');



%% Plot all shocks
% figure(); orient landscape;
% 
% prange = qq(2014,1):qq(2017,4);
% 
% elist = {'mes_lgdp','mes_lgdp_eq', ...
%     'e_lgdp','e_lcpi','e_dot_cpi_core','e_dot_cpi_food', ...
%     'e_dot_pm','e_ls','e_rn','e_target','e_lx_gdp', ... 
%     'e_x_rn','e_dot_x_cpi','e_x_rr_eq','e_rr_eq', ...
%     'e_dot_z_eq','e_prem','e_dot_gdp_eq','e_dot_rw_eq', ...
%     'e_dot_rp_food_eq','e_dot_rp_food_eq_ss','e_dot_qfood_eq', ...
%     'e_lqfood','e_dot_cpi_elec','e_dl_rp_elec_eq', ...
%     'e_dot_cpi_petr','e_dot_rp_petr_eq','e_dot_rp_petr_eq_ss', ...
%     'e_dot_qoil_eq','e_lqoil'};
% 
% nlist = {'mes\_lgdp\','mes\_lgdp\_eq', ...
%     'e\_lgdp\','e\_lcpi','e\_dot\_cpi\_core','e\_dot\_cpi\_food', ...
%     'e\_dot\_pm','e\_ls','e\_rn','e\_target','e\_lx\_gdp\', ... 
%     'e\_x\_rn','e\_dot\_x\_cpi','e\_x\_rr\_eq','e\_rr\_eq', ...
%     'e\_dot\_z\_eq','e\_prem','e\_dot\_gdp\_eq','e\_dot\_rw\_eq', ...
%     'e\_dot\_rp\_food\_eq','e\_dot\_rp\_food\_eq\_ss','e\_dot\_qfood\_eq', ...
%     'e\_lqfood\','e\_dot\_cpi\_elec','e\_dl\_rp\_elec\_eq', ...
%     'e\_dot\_cpi\_petr','e\_dot\_rp\_petr\_eq','e\_dot\_rp\_petr\_eq\_ss', ...
%     'e\_dot\_qoil\_eq','e\_lqoil\'};
% 
% for i = 1:numel(elist)
% subplot(6,5,i);
% bar(prange,s.(elist{i}),'EdgeColor',[1 1 1],'dateFormat=','YYFP'); 
% title(nlist{i});
% highlight(mpcrng);
% end
% 
% % print('-dpdf','outputs\shocks.pdf');
% 
% % return

% nrows = 2;
% ncols = 4;
% tilefigs([nrows ncols],10);
% pause;